/**
* \file: AilAudioOut.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AILAUDIOOUT_H
#define CARPLAY_AILAUDIOOUT_H

#include <carplay_plugin.h>

namespace adit { namespace carplay
{

class AilAudioOut : public IAudioOutAdapter
{
public :
    AilAudioOut();
    virtual ~AilAudioOut();

    // IAudioOutAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioOutSource& inSource);
    virtual bool Prepare(AudioFormatStruct inFormat, AudioChannelType inChannel, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();
    virtual void Flush();

    // private section
private:
    class Impl;
    Impl* impl;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AILAUDIOOUT_H */
